// ALP Area of Interest Sample.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "alp.h"
#include <memory>
#include <windows.h> 
#include <stdio.h>
#include <NIDAQmx.h>


#define DAQmxErrChk(functionCall) if( DAQmxFailed(error=(functionCall)) ) goto Error; else

int32 CVICALLBACK EveryNCallback(TaskHandle taskHandle, int32 everyNsamplesEventType, uInt32 nSamples, void* callbackData);
int32 CVICALLBACK DoneCallback(TaskHandle taskHandle, int32 status, void* callbackData);

// Error handling policy: Quit, whenever an ALP error happens. ////////////////
#define VERIFY_ALP(AlpApiCall) { long Ret=AlpApiCall; if (ALP_OK!=Ret) { _tprintf( _T("ALP API Error Code %i (see alp.h) in function\r\n %s\r\nPress any key to exit."), Ret, _T(#AlpApiCall) );if (taskHandle != 0) {DAQmxStopTask(taskHandle);DAQmxClearTask(taskHandle);} _gettch(); return 1;} }

#define PRESS_KEY(strMessage) {	_tprintf( strMessage ); while (_kbhit()) _gettch(); _gettch();}


int _tmain(int /* argc */, _TCHAR* /* argv */[])
{
	_tprintf(_T("This ALP Area of Interest Sample demonstrates \r\nhow to correctly combine Area of Interest with \r\ndata download via AlpSeqPutEx. \r\n------------------------------------------------------------------\r\n\r\n"));



	// General declarations and definitions ///////////////////////////////////////
	ALP_ID AlpDevId = 0;
	ALP_ID AlpSeqId = 0;
	long nRows = 0;
	long nColumns = 0;

//	long nFrames = 278528;
//	long nFrames = 262144;
//	long nFrames = 87381;
	long nFrames = 69632;
//	long nFrames = 65536;
//	long nFrames = 32896;
//	long nFrames = 17408;
//	long nFrames = 16384;
//	long nFrames = 4096;
//	long nFrames = 1024;
//	long nFrames = 32;
//	long nFrames = 8;

	long picoffset = 0;
//	long txtframes = 8192;
//	long txtframes = 2048;
	long txtframes = 1024;
//	long txtframes = 512;
//	long txtframes = 128;
//	long txtframes = 32;
//	long txtframes = 1;

//	long txtperframes = 32;
//	long txtperframes = 34;
	long txtperframes = 68;
//	long txtperframes = 136;

//	long nSeqFrames	= 0;
	long nAoiFirstRow = 0;
	long nAoiRowCount = 0;
	long nMaxPicNum = 0;
	long nMinPicTime = 0;
//	long nPicTime = 1000000;
	long dmdtype = 0;
	long dmdmemory = 0;

	long PicTime = 40;
	long lSize;
//	char address[] = "F:\\daixuan\\C_programme\\data_image128_8bitplane_russia2_txt\\modulation_intensity_";
//	char address[] = "F:\\daixuan\\C_programme\\128_8bitplane_kron4_unchange1\\modulation_intensity_";
//	char address[] = "F:\\daixuan\\C_programme\\data_image128_8bitplane_russia_persuitbasis_txt\\modulation_intensity_";
//	char address[] = "F:\\daixuan\\C_programme\\data_image256_8bitplane_russia_persuitbasis2_txt\\modulation_intensity_";
//	char address[] = "F:\\daixuan\\C_programme\\data_image128_1_1_8bitplane_russia_persuitbasis_txt\\modulation_intensity_";
//	char address[] = "F:\\daixuan\\C_programme\\data_image256_1_1_8bitplane_russia_persuitbasis_txt\\modulation_intensity_";
//	char address[] = "F:\\daixuan\\C_programme\\data_image256_2_2_alter_8bitplane_russia_persuitbasis_txt\\modulation_intensity_";
//	char address[] = "F:\\daixuan\\C_programme\\data_image256_2_2_alter_8bitplane_russia_persuitbasis2_txt\\modulation_intensity_";
	char address[] = "F:\\daixuan\\C_programme\\data_image256_3_3_8bitplane_russia_persuitbasis2_txt\\modulation_intensity_";
//	char address[] = "F:\\daixuan\\C_programme\\data_image512_1_1_8bitplane_russia_persuitbasis2_txt\\modulation_intensity_";

//	char log;
	char txt[] = ".txt";
	char* result = nullptr;
	UCHAR* pos = nullptr;
	printf("the address is %s\n", address);
	const char* result1 = nullptr;

	// daq errorbuff////////////////
	int32       error = 0;
	TaskHandle  taskHandle = 0;
	char        errBuff[2048] = { '\0' };

	tAlpLinePut AlpLinePut;

	// Initialize ALP /////////////////////////////////////////////////////////////
	VERIFY_ALP(AlpDevAlloc(0, 0, &AlpDevId));

	VERIFY_ALP(AlpDevInquire(AlpDevId, ALP_DEV_DISPLAY_HEIGHT, &nRows));
	VERIFY_ALP(AlpDevInquire(AlpDevId, ALP_DEV_DISPLAY_WIDTH, &nColumns));
	VERIFY_ALP(AlpDevInquire(AlpDevId, ALP_DEV_DMDTYPE, &dmdtype));
	VERIFY_ALP(AlpDevInquire(AlpDevId, ALP_AVAIL_MEMORY, &dmdmemory));
	_tprintf(_T("The rows and columns of DMD is %i , %i , DMDtype is %i (see the discription) and largest number of image is %i \r\n"), nRows, nColumns, dmdtype, dmdmemory);

//	nAoiFirstRow = 128;
//	nAoiRowCount = 512;

//	VERIFY_ALP(AlpDevControl(AlpDevId, ALP_SEQ_DMD_LINES, MAKELONG(nAoiFirstRow, nAoiRowCount)));

	// Set up Sequence ////////////////////////////////////////////////////////////
	std::unique_ptr<char unsigned[]> pSeqData(new char unsigned[nRows * nColumns]);

	VERIFY_ALP(AlpSeqAlloc(AlpDevId, 1, nFrames, &AlpSeqId));

	// Set up the AOI for the Sequence
//	VERIFY_ALP(AlpSeqControl(AlpDevId, AlpSeqId, ALP_SEQ_DMD_LINES, MAKELONG(nAoiFirstRow, nAoiRowCount)));
	VERIFY_ALP(AlpSeqControl(AlpDevId, AlpSeqId, ALP_BIN_MODE, ALP_BIN_UNINTERRUPTED)); //without dark phase!
//	VERIFY_ALP(AlpSeqControl(AlpDevId, AlpSeqId, ALP_BIN_MODE, ALP_DEFAULT)); //with dark phase.

	VERIFY_ALP(AlpSeqControl(AlpDevId, AlpSeqId, ALP_DATA_FORMAT, ALP_DATA_BINARY_TOPDOWN));

	VERIFY_ALP(AlpSeqInquire(AlpDevId, AlpSeqId, ALP_PICNUM, &nMaxPicNum));
	_tprintf(_T("Frame number of the sequence: %i Hz \r\n"), nMaxPicNum);

	// Inquire minimum PictureTime
	VERIFY_ALP(AlpSeqInquire(AlpDevId, AlpSeqId, ALP_MIN_PICTURE_TIME, &nMinPicTime));
	_tprintf(_T("Maximum Frame rate of the sequence: %i Hz \r\n"), 1000000 / nMinPicTime);

//	PicTime = nMinPicTime + 2;
//	PicTime = 30000;
//	PicTime = 64;
	PicTime = 48;
//	PicTime = 160;

	// Activate AOI for the Sequence
	VERIFY_ALP(AlpSeqTiming(AlpDevId, AlpSeqId, ALP_DEFAULT, PicTime, ALP_DEFAULT, ALP_DEFAULT, ALP_DEFAULT));
	_tprintf(_T("Current Frame rate of the sequence: %i Hz \r\n\r\n"), 1000000 / PicTime);

	for (long frameoffset = 0; frameoffset < txtframes; frameoffset++)
	{
		result = (char*)malloc(strlen(address) + strlen(txt) + 1);
		sprintf(result, "%s%d%s", address, frameoffset, txt);
		result1 = result;
		printf("the address is %s\n", result1);

//		AlpLinePut.TransferMode = ALP_PUT_LINES;
//		AlpLinePut.LineOffset = ALP_DEFAULT;
//		AlpLinePut.LineLoad = ALP_DEFAULT;
//		AlpLinePut.PicOffset = frameoffset;
//		AlpLinePut.PicLoad = 8;
		picoffset = frameoffset * txtperframes;

		FILE * fin = fopen(result1, "rb");
		if (fin == NULL)
		{
			_tprintf(_T("openning file go wrong, please press any key to exit."));
			_gettch();
			return 1;
		}
		fseek(fin, 0, SEEK_END);
		lSize = ftell(fin);
		rewind(fin);
		//ٴ洢ռ
		int num = lSize / sizeof(UCHAR);
		pos = (UCHAR*)malloc(sizeof(UCHAR) * num);
	//	printf("the storage is %d\n", sizeof(UCHAR) * num);
		if (pos == NULL)
		{
			printf("ٿռ");
			return 1;
		}
		fread(pos, sizeof(UCHAR), num, fin);
		//		for (long count = 0; count < nAoiRowCount*nColumns; count++)
		//		{
		//			pSeqData[count] = (int)pos[count];
		//			printf("%d\n", pos[count]);
		//		}

		//		VERIFY_ALP(AlpSeqPutEx(AlpDevId, AlpSeqId, &AlpLinePut, pSeqData.get()));
		VERIFY_ALP(AlpSeqPut(AlpDevId, AlpSeqId, picoffset, txtperframes, pos));

		free(pos);
		fclose(fin);

	//	result = (char*)malloc(strlen(address) + strlen(txt) + 1);
	}
	VERIFY_ALP(AlpSeqControl(AlpDevId, AlpSeqId, ALP_LINE_INC, 0));

	/*********************************************/
	// DAQmx Configure Code
	/*********************************************/
	DAQmxErrChk(DAQmxCreateTask("", &taskHandle));
	DAQmxErrChk(DAQmxCreateAIVoltageChan(taskHandle, "Dev1/ai3", "", DAQmx_Val_Diff, -0.1, 0.1, DAQmx_Val_Volts, NULL));//DAQmx_Val_Cfg_Default,DAQmx_Val_Diff,DAQmx_Val_RSE
	DAQmxErrChk(DAQmxCfgSampClkTiming(taskHandle, "", 1250000.0, DAQmx_Val_Rising, DAQmx_Val_ContSamps, 4096));

	DAQmxErrChk(DAQmxRegisterEveryNSamplesEvent(taskHandle, DAQmx_Val_Acquired_Into_Buffer, 4096, 0, EveryNCallback, NULL));
	DAQmxErrChk(DAQmxRegisterDoneEvent(taskHandle, 0, DoneCallback, NULL));

	DAQmxErrChk(DAQmxConfigureLogging(taskHandle, "F:\\daixuan\\DAQ_example_text\\20201117\\example8.tdms", DAQmx_Val_LogAndRead, "GroupName", DAQmx_Val_OpenOrCreate));

	/*********************************************/
	// DAQmx Start Code
	/*********************************************/
	DAQmxErrChk(DAQmxStartTask(taskHandle));

//	printf("Acquiring samples continuously. Press Enter to interrupt\n");
//	getchar();

	// Start projection ///////////////////////////////////////////////////////////
	VERIFY_ALP(AlpProjStartCont(AlpDevId, AlpSeqId));

	PRESS_KEY(_T("Starting sequence-display. Press any key to exit.\r\n\r\n"));

	// Deallocate device //////////////////////////////////////////////////////////
	VERIFY_ALP(AlpDevHalt(AlpDevId));
	VERIFY_ALP(AlpDevFree(AlpDevId));

//	return 0;

Error:
	if (DAQmxFailed(error))
		DAQmxGetExtendedErrorInfo(errBuff, 2048);
	if (taskHandle != 0) {
		/*********************************************/
		// DAQmx Stop Code
		/*********************************************/
		DAQmxStopTask(taskHandle);
		DAQmxClearTask(taskHandle);
	}
	if (DAQmxFailed(error))
		printf("DAQmx Error: %s\n", errBuff);
	printf("End of program, press Enter key to quit\n");
	getchar();
	return 1;
}

int32 CVICALLBACK EveryNCallback(TaskHandle taskHandle, int32 everyNsamplesEventType, uInt32 nSamples, void* callbackData)
{
	int32       error = 0;
	char        errBuff[2048] = { '\0' };
	static int  totalRead = 0;
	int32       read = 0;
	float64     data[4096];

	/*********************************************/
	// DAQmx Read Code
	/*********************************************/
	DAQmxErrChk(DAQmxReadAnalogF64(taskHandle, 4096, 10.0, DAQmx_Val_GroupByScanNumber, data, 4096, &read, NULL));
	if (read > 0) {
		printf("Acquired %d samples. Total %d\r", (int)read, (int)(totalRead += read));
		fflush(stdout);
	}

Error:
	if (DAQmxFailed(error)) {
		DAQmxGetExtendedErrorInfo(errBuff, 2048);
		/*********************************************/
		// DAQmx Stop Code
		/*********************************************/
		DAQmxStopTask(taskHandle);
		DAQmxClearTask(taskHandle);
		printf("DAQmx Error: %s\n", errBuff);
	}
	return 1;
}

int32 CVICALLBACK DoneCallback(TaskHandle taskHandle, int32 status, void* callbackData)
{
	int32   error = 0;
	char    errBuff[2048] = { '\0' };

	// Check to see if an error stopped the task.
	DAQmxErrChk(status);

Error:
	if (DAQmxFailed(error)) {
		DAQmxGetExtendedErrorInfo(errBuff, 2048);
		DAQmxClearTask(taskHandle);
		printf("DAQmx Error: %s\n", errBuff);
	}
	return 1;
}